local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// list layout.
	self.Layout = CtlListLayout_class:create( self );
	self.Layout:SetSpacing( 2 );

	// create the header.
	self.Header = CtlHeader_class:create( self.Layout:GetHandle() );
	self.Header:SetPos( 4, 4 );
	self.Header:SetSize( 128, 32 );
	self.Header:SetTitle( "Settings" );
	self.Layout:AddItem( self.Header );
	
	// create cache
	self.Cache = CtlContextCheckBox_class:create( self.Layout:GetHandle() );
	self.Cache:SetConVar( nil );
	self.Cache:SetText( "Cache" );
	self.Cache:SetSize( 32, 32 );
	self.Layout:AddItem( self.Cache );
	
	// create multispawn
	self.Multispawn = CtlContextCheckBox_class:create( self.Layout:GetHandle() );
	self.Multispawn:SetConVar( nil );
	self.Multispawn:SetText( "Multi-Spawn" );
	self.Multispawn:SetSize( 32, 32 );
	self.Layout:AddItem( self.Multispawn );
	
	// create force delay spawn
	self.ForceDelay = CtlContextCheckBox_class:create( self.Layout:GetHandle() );
	self.ForceDelay:SetConVar( nil );
	self.ForceDelay:SetText( "Force Delay Spawning" );
	self.ForceDelay:SetSize( 32, 32 );
	self.Layout:AddItem( self.ForceDelay );
	
end


// perform layout
function PANEL:PerformLayout( )
	// position the layout
	self.Layout:SetPos( 4, 4 );
	self.Layout:SetSize( self:GetWide() - 8, self:GetTall() - 8 );
	
	// update
	self.Layout:Update();

end


// draw
function PANEL:Paint( )
	// pain background.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_settings_panel", PANEL, "Panel" );


// create app framework control.
CtlSettingsPanel_class 	= Control_class:create( nil, false, "ctl_settings_panel" );
